import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { selectors } from '@grafana/e2e-selectors';
import { EditorRows, EditorRow, EditorField, EditorSwitch } from '@grafana/plugin-ui';
import { AutoSizeInput, Space, Input } from '@grafana/ui';
import { PromQueryCodeEditor } from '../querybuilder/components/PromQueryCodeEditor.mjs';

function AnnotationQueryEditor(props) {
  const annotation = props.annotation;
  const onAnnotationChange = props.onAnnotationChange;
  const query = { expr: annotation.expr, refId: annotation.name, interval: annotation.step };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(EditorRows, { children: [
      /* @__PURE__ */ jsx(
        PromQueryCodeEditor,
        {
          ...props,
          query,
          showExplain: false,
          onChange: (query2) => {
            onAnnotationChange({
              ...annotation,
              expr: query2.expr
            });
          }
        }
      ),
      /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Min step",
          tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
            "An additional lower limit for the step parameter of the Prometheus query and for the",
            " ",
            /* @__PURE__ */ jsx("code", { children: "$__interval" }),
            " and ",
            /* @__PURE__ */ jsx("code", { children: "$__rate_interval" }),
            " variables."
          ] }),
          children: /* @__PURE__ */ jsx(
            AutoSizeInput,
            {
              type: "text",
              "aria-label": "Set lower limit for the step parameter",
              placeholder: "auto",
              minWidth: 10,
              onCommitChange: (ev) => {
                onAnnotationChange({
                  ...annotation,
                  step: ev.currentTarget.value
                });
              },
              defaultValue: query.interval,
              id: selectors.components.DataSource.Prometheus.annotations.minStep
            }
          )
        }
      ) })
    ] }),
    /* @__PURE__ */ jsx(Space, { v: 0.5 }),
    /* @__PURE__ */ jsxs(EditorRow, { children: [
      /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Title",
          tooltip: "Use either the name or a pattern. For example, {{instance}} is replaced with label value for the label instance.",
          children: /* @__PURE__ */ jsx(
            Input,
            {
              type: "text",
              placeholder: "{{alertname}}",
              value: annotation.titleFormat,
              onChange: (event) => {
                onAnnotationChange({
                  ...annotation,
                  titleFormat: event.currentTarget.value
                });
              },
              "data-testid": selectors.components.DataSource.Prometheus.annotations.title
            }
          )
        }
      ),
      /* @__PURE__ */ jsx(EditorField, { label: "Tags", children: /* @__PURE__ */ jsx(
        Input,
        {
          type: "text",
          placeholder: "label1,label2",
          value: annotation.tagKeys,
          onChange: (event) => {
            onAnnotationChange({
              ...annotation,
              tagKeys: event.currentTarget.value
            });
          },
          "data-testid": selectors.components.DataSource.Prometheus.annotations.tags
        }
      ) }),
      /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Text",
          tooltip: "Use either the name or a pattern. For example, {{instance}} is replaced with label value for the label instance.",
          children: /* @__PURE__ */ jsx(
            Input,
            {
              type: "text",
              placeholder: "{{instance}}",
              value: annotation.textFormat,
              onChange: (event) => {
                onAnnotationChange({
                  ...annotation,
                  textFormat: event.currentTarget.value
                });
              },
              "data-testid": selectors.components.DataSource.Prometheus.annotations.text
            }
          )
        }
      ),
      /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Series value as timestamp",
          tooltip: "The unit of timestamp is milliseconds. If the unit of the series value is seconds, multiply its range vector by 1000.",
          children: /* @__PURE__ */ jsx(
            EditorSwitch,
            {
              value: annotation.useValueForTime,
              onChange: (event) => {
                onAnnotationChange({
                  ...annotation,
                  useValueForTime: event.currentTarget.value
                });
              },
              "data-testid": selectors.components.DataSource.Prometheus.annotations.seriesValueAsTimestamp
            }
          )
        }
      )
    ] })
  ] });
}

export { AnnotationQueryEditor };
//# sourceMappingURL=AnnotationQueryEditor.mjs.map
