import { jsx } from 'react/jsx-runtime';
import { RadioButtonGroup } from '@grafana/ui';
import { QueryEditorMode } from './types.mjs';

const editorModes = [
  { label: "Builder", value: QueryEditorMode.Builder },
  { label: "Code", value: QueryEditorMode.Code }
];
function QueryEditorModeToggle({ mode, onChange }) {
  return /* @__PURE__ */ jsx("div", { "data-testid": "QueryEditorModeToggle", children: /* @__PURE__ */ jsx(RadioButtonGroup, { options: editorModes, size: "sm", value: mode, onChange }) });
}

export { QueryEditorModeToggle };
//# sourceMappingURL=QueryEditorModeToggle.mjs.map
