import { of, from } from 'rxjs';
import { map } from 'rxjs/operators';
import { CustomVariableSupport, rangeUtil } from '@grafana/data';
import { getTemplateSrv } from '@grafana/runtime';
import { PromVariableQueryEditor } from './components/VariableQueryEditor.mjs';
import { PrometheusMetricFindQuery } from './metric_find_query.mjs';

class PrometheusVariableSupport extends CustomVariableSupport {
  constructor(datasource, templateSrv = getTemplateSrv()) {
    super();
    this.datasource = datasource;
    this.templateSrv = templateSrv;
    this.editor = PromVariableQueryEditor;
  }
  query(request) {
    let query;
    if (typeof request.targets[0] === "string") {
      query = request.targets[0];
    } else {
      query = request.targets[0].query;
    }
    if (!query) {
      return of({ data: [] });
    }
    const scopedVars = {
      ...request.scopedVars,
      __interval: { text: this.datasource.interval, value: this.datasource.interval },
      __interval_ms: {
        text: rangeUtil.intervalToMs(this.datasource.interval),
        value: rangeUtil.intervalToMs(this.datasource.interval)
      },
      ...this.datasource.getRangeScopedVars(request.range)
    };
    const interpolated = this.templateSrv.replace(query, scopedVars, this.datasource.interpolateQueryExpr);
    const metricFindQuery = new PrometheusMetricFindQuery(this.datasource, interpolated);
    const metricFindStream = from(metricFindQuery.process(request.range));
    return metricFindStream.pipe(map((results) => ({ data: results })));
  }
}

export { PrometheusVariableSupport };
//# sourceMappingURL=variables.mjs.map
