import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';

const TimeZoneGroup = (props) => {
  const { children, label } = props;
  const styles = useStyles2(getStyles);
  if (!label) {
    return /* @__PURE__ */ jsx("div", { children });
  }
  return /* @__PURE__ */ jsxs("div", { children: [
    /* @__PURE__ */ jsx("div", { className: styles.header, children: /* @__PURE__ */ jsx("span", { className: styles.label, children: label }) }),
    children
  ] });
};
const getStyles = (theme) => {
  return {
    header: css({
      padding: "7px 10px",
      width: "100%",
      borderTop: `1px solid ${theme.colors.border.weak}`,
      textTransform: "capitalize"
    }),
    label: css({
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

export { TimeZoneGroup };
//# sourceMappingURL=TimeZoneGroup.mjs.map
