import { jsxs, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { useDialog } from '@react-aria/dialog';
import { FocusScope } from '@react-aria/focus';
import { useOverlay, OverlayContainer } from '@react-aria/overlays';
import { useRef } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { t } from '../../utils/i18n.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';
import { ModalHeader } from './ModalHeader.mjs';
import { getModalStyles } from './getModalStyles.mjs';

function Modal(props) {
  const {
    title,
    children,
    isOpen = false,
    closeOnEscape = true,
    closeOnBackdropClick = true,
    className,
    contentClassName,
    onDismiss,
    onClickBackdrop,
    trapFocus = true
  } = props;
  const styles = useStyles2(getModalStyles);
  const ref = useRef(null);
  const { overlayProps, underlayProps } = useOverlay(
    { isKeyboardDismissDisabled: !closeOnEscape, isOpen, onClose: onDismiss },
    ref
  );
  const { dialogProps, titleProps } = useDialog({}, ref);
  if (!isOpen) {
    return null;
  }
  const headerClass = cx(styles.modalHeader, typeof title !== "string" && styles.modalHeaderWithTabs);
  return /* @__PURE__ */ jsxs(OverlayContainer, { children: [
    /* @__PURE__ */ jsx(
      "div",
      {
        role: "presentation",
        className: styles.modalBackdrop,
        onClick: onClickBackdrop || (closeOnBackdropClick ? onDismiss : undefined),
        ...underlayProps
      }
    ),
    /* @__PURE__ */ jsx(FocusScope, { contain: trapFocus, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxs("div", { className: cx(styles.modal, className), ref, ...overlayProps, ...dialogProps, children: [
      /* @__PURE__ */ jsxs("div", { className: headerClass, children: [
        typeof title === "string" && /* @__PURE__ */ jsx(DefaultModalHeader, { ...props, title, id: titleProps.id }),
        // FIXME: custom title components won't get an accessible title.
        // Do we really want to support them or shall we just limit this ModalTabsHeader?
        typeof title !== "string" && title,
        /* @__PURE__ */ jsx("div", { className: styles.modalHeaderClose, children: /* @__PURE__ */ jsx(
          IconButton,
          {
            name: "times",
            size: "xl",
            onClick: onDismiss,
            "aria-label": t("grafana-ui.modal.close-tooltip", "Close")
          }
        ) })
      ] }),
      /* @__PURE__ */ jsx("div", { className: cx(styles.modalContent, contentClassName), children })
    ] }) })
  ] });
}
function ModalButtonRow({ leftItems, children }) {
  const styles = useStyles2(getModalStyles);
  if (leftItems) {
    return /* @__PURE__ */ jsx("div", { className: styles.modalButtonRow, children: /* @__PURE__ */ jsxs(Stack, { justifyContent: "space-between", children: [
      /* @__PURE__ */ jsx(Stack, { justifyContent: "flex-start", gap: 2, children: leftItems }),
      /* @__PURE__ */ jsx(Stack, { justifyContent: "flex-end", gap: 2, children })
    ] }) });
  }
  return /* @__PURE__ */ jsx("div", { className: styles.modalButtonRow, children: /* @__PURE__ */ jsx(Stack, { justifyContent: "flex-end", gap: 2, wrap: "wrap", children }) });
}
Modal.ButtonRow = ModalButtonRow;
function DefaultModalHeader({ icon, iconTooltip, title, id }) {
  return /* @__PURE__ */ jsx(ModalHeader, { icon, iconTooltip, title, id });
}

export { Modal };
//# sourceMappingURL=Modal.mjs.map
