import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { CustomScrollbar } from '../../components/CustomScrollbar/CustomScrollbar.mjs';
import { VizLegend } from '../../components/VizLegend/VizLegend.mjs';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { Graph } from './Graph.mjs';

const shouldHideLegendItem = (data, hideEmpty = false, hideZero = false) => {
  const isZeroOnlySeries = data.reduce((acc, current) => acc + (current[1] || 0), 0) === 0;
  const isNullOnlySeries = !data.reduce((acc, current) => acc && current[1] !== null, true);
  return hideEmpty && isNullOnlySeries || hideZero && isZeroOnlySeries;
};
const GraphWithLegend = (props) => {
  const {
    series,
    timeRange,
    width,
    height,
    showBars,
    showLines,
    showPoints,
    sortLegendBy,
    sortLegendDesc,
    legendDisplayMode,
    legendVisibility,
    placement,
    onSeriesToggle,
    onToggleSort,
    hideEmpty,
    hideZero,
    isStacked,
    lineWidth,
    onHorizontalRegionSelected,
    timeZone,
    children,
    ariaLabel
  } = props;
  const { graphContainer, wrapper, legendContainer } = useStyles2(getGraphWithLegendStyles, props.placement);
  const legendItems = series.reduce((acc, s) => {
    return shouldHideLegendItem(s.data, hideEmpty, hideZero) ? acc : acc.concat([
      {
        label: s.label,
        color: s.color || "",
        disabled: !s.isVisible,
        yAxis: s.yAxis.index,
        getDisplayValues: () => s.info || []
      }
    ]);
  }, []);
  return /* @__PURE__ */ jsxs("div", { className: wrapper, "aria-label": ariaLabel, children: [
    /* @__PURE__ */ jsx("div", { className: graphContainer, children: /* @__PURE__ */ jsx(
      Graph,
      {
        series,
        timeRange,
        timeZone,
        showLines,
        showPoints,
        showBars,
        width,
        height,
        isStacked,
        lineWidth,
        onHorizontalRegionSelected,
        children
      }
    ) }),
    legendVisibility && /* @__PURE__ */ jsx("div", { className: legendContainer, children: /* @__PURE__ */ jsx(CustomScrollbar, { hideHorizontalTrack: true, children: /* @__PURE__ */ jsx(
      VizLegend,
      {
        items: legendItems,
        displayMode: legendDisplayMode,
        placement,
        sortBy: sortLegendBy,
        sortDesc: sortLegendDesc,
        onLabelClick: (item, event) => {
          if (onSeriesToggle) {
            onSeriesToggle(item.label, event);
          }
        },
        onToggleSort
      }
    ) }) })
  ] });
};
const getGraphWithLegendStyles = (_theme, placement) => ({
  wrapper: css({
    display: "flex",
    flexDirection: placement === "bottom" ? "column" : "row"
  }),
  graphContainer: css({
    minHeight: "65%",
    flexGrow: 1
  }),
  legendContainer: css({
    padding: "10px 0",
    maxHeight: placement === "bottom" ? "35%" : "none"
  })
});

export { GraphWithLegend };
//# sourceMappingURL=GraphWithLegend.mjs.map
